<?php
/*--------------------------------------------------------------------------------------------------
    customers_info_repair.php 2022-10-26
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2022 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

/** @var DatabaseModel $this */
/** @var int $t_success */

$sql = <<<SQL
SELECT c.customers_id, c.customers_date_added, c.customers_last_modified FROM `customers` c
	LEFT JOIN `customers_info` ci ON ci.customers_info_id = c.customers_id
WHERE ci.customers_info_id IS NULL;
SQL;

$result = $this->query($sql, true);

if ($result->num_rows > 0) {
    $insertCustomersInfoQuery = "INSERT INTO `customers_info` (`customers_info_id`, `customers_info_number_of_logons`, `customers_info_date_account_created`, `customers_info_date_account_last_modified`) VALUES ";
    
    while ($row = $result->fetch_assoc()) {
        $customersInfoAccountCreated = $this->real_escape_string($row['customers_date_added']);
        $customersInfoLastModified   = $this->real_escape_string($row['customers_last_modified']);
        $customersInfoId             = $this->real_escape_string($row['customers_id']);
        $customersInfoNumLogons      = 0;
        
        $insertCustomersInfoQuery .= "({$customersInfoId}, {$customersInfoNumLogons}, '{$customersInfoAccountCreated}', '{$customersInfoLastModified}'),";
    }
    
    $insertCustomersInfoQuery = rtrim($insertCustomersInfoQuery, ',');
    
    $t_success &= $this->query($insertCustomersInfoQuery, true);
}